<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Setting;
use App\Models\Language;
use App\Models\Posts;
use Illuminate\Support\Str;
use Storage;
use File;
use ZipArchive;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
     
    public function downloadCategory($id)
    {
        
        $category = Category::find($id);
        $path = public_path().'/backup/';
        
        File::deleteDirectory($path);
        if(!File::exists($path)){
            File::makeDirectory($path, $mode = 0777, true, true);
        }
        
        $path2 = public_path().'/backup/'.$category->name;
        if(!File::exists($path2)){
            File::makeDirectory($path2, $mode = 0777, true, true);
        }
        
        $languages = Language::get();
        foreach ($languages as $language){
            $path3 = public_path().'/backup/'.$category->name.'/'.$language->language_code;
            if(!File::exists($path3)){
                File::makeDirectory($path3, $mode = 0777, true, true);
            }
            
            $posts = Posts::where('category_id',$id)->where('language',$language->language_code)->get();
            foreach ($posts as $post){
                \File::copy($post->item_url,$path3.'/'.basename($post->item_url));
            }
            
            $fileName = '/backup/'.$category->name.'/'.$language->language_code.'.zip';
            
            $zip = new ZipArchive;
            if ($zip->open(public_path($fileName), ZipArchive::CREATE) === TRUE)
            {
                $files = File::files($path3);
       
                foreach ($files as $key => $value) {
                    $relativeNameInZipFile = basename($value);
                    $zip->addFile($value, $relativeNameInZipFile);
                }
                 
                $zip->close();
            }
            
        }
        
        
   
        
   
        $fileName = '/backup/'.$category->name.'.zip';
            
        $zip = new ZipArchive;
        if ($zip->open(public_path($fileName), ZipArchive::CREATE) === TRUE)
        {
            $files = File::files($path2);
      
            foreach ($files as $key => $value) {
                $relativeNameInZipFile = basename($value);
                $zip->addFile($value, $relativeNameInZipFile);
            }
             
            $zip->close();
        }
    
        return response()->download(public_path($fileName));
        
    }
    
    public function index()
    {
      
        $data['categories'] = Category::orderBy('id', 'DESC')->paginate(12);
        $data['type'] = "";
        return view('category.index',$data);
    }
    
    public function festivalCategory()
    {
      
        $data['categories'] = Category::where('type','festival')->orderBy('event_date', 'DESC')->paginate(12);
        $data['type'] = "festival";
        return view('category.index',$data);
    }
    
    public function businessCategory()
    {
      
        $data['categories'] = Category::where('type','business')->orderBy('id', 'DESC')->paginate(12);
        $data['type'] = "business";
        return view('category.index',$data);
    }
    
    public function getCategoryByType(Request $request)
    {
        return Category::where('type',$request->get('type'))->where('status','0')->orderBy('id', 'DESC')->get();
    }
    
    public function customCategory()
    {
      
        $data['categories'] = Category::where('type','custom')->orderBy('id', 'DESC')->paginate(12);
        $data['type'] = "custom";
        return view('category.index',$data);
    }
    
    public function politicalCategory()
    {
      
        $data['categories'] = Category::where('type','political')->orderBy('id', 'DESC')->paginate(12);
        $data['type'] = "political";
        return view('category.index',$data);
    }
    
    public function searchCategory(Request $request)
    {
        $data['type'] = $request->get("type");
        if($request->get("search") != ""){
            $data['search'] = $request->get("search");
            $data['categories'] = Category::where('type',$request->get("type"))->where('name','like',"%".$request->get("search")."%")->orWhere('event_date','like',"%".$request->get("search")."%")->get();
        }else{
            $data['categories'] = Category::where('type',$request->get("type"))->orderBy('id', 'DESC')->paginate(12);
        }
        
        return view('category.index',$data);
    }
    
    
    public function filterby_type($type)
    {
      
        $data['categories'] = Category::where('type',$type)->orderBy('id', 'DESC')->paginate(12);
        $data['type'] = $type;
        return view("category.index", $data);
    }
    
    public function category_status(Request $request)
    {
        // echo("okk");
        $festivals = Category::find($request->get("id"));
        $festivals->status = ($request->get("checked")=="true")?0:1;
        $festivals->save();
        
    }
    
    public function categoryFeatured(Request $request)
    {
        // echo("okk");
        $festivals = Category::find($request->get("id"));
        $festivals->featured = ($request->get("checked")=="true")?1:0;
        $festivals->save();
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
      
        return view("category.create");
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
             'image' => 'required|mimes:jpg,png,jpeg',
             'title' => 'required',
             'type' => 'required',
        ]);
        
        $posts = new Category();
        $posts->name = $request->get("title");
        $posts->type = $request->get("type");
        
        if($request->get("type") == 'festival'){
            $posts->event_date = $request->get("event_date");
        }
        
        
        if ($request->file("image") && $request->file('image')->isValid()) {
            $image = $request->file("image");
            
            $extension = $image->getClientOriginalExtension();
            $fileName = Str::uuid() . '.' . $extension;
            
            if(Setting::getValue('storage_type') == "digitalOccean"){
                $item_url = Storage::disk('spaces')->put('uploads/posts/'.$fileName, file_get_contents($image),'public');
                $thumbnail_url = env("DO_SPACES_URL").'/uploads/posts/'.$fileName;
                $posts->image = $thumbnail_url;
            }else{
                
                $thumbName = Str::uuid() . '.' .$extension;
            
                $image->move('uploads/posts', $fileName);
                $item_url = 'uploads/posts/'.$fileName;
              
                if($request->get("type") == "political"){
                  $posts->image = $item_url;
                }else{
                  $thumbnail_url = 'uploads/posts/'.$thumbName;

                    switch($extension){ 
                        case 'jpeg':
                            $image = imagecreatefromjpeg($item_url); 
                            break; 
                        case 'png': 
                            $image = imagecreatefrompng($item_url); 
                            break; 
                        case 'gif': 
                            $image = imagecreatefromgif($item_url); 
                            break; 
                        default: 
                            $image = imagecreatefromjpeg($item_url); 
                    }

                    imagejpeg($image, $thumbnail_url, 50);
                   @unlink($item_url);
                  
                  $posts->image = $thumbnail_url;
                }
                
            }
            
        }
        
        $posts->save();
        if($request->get("type") == "festival"){
            return redirect('/festivalCategory');
        }
        if($request->get("type") == "business"){
            return redirect('/businessCategory');
        }
        if($request->get("type") == "political"){
            return redirect('/politicalCategory');
        }
        if($request->get("type") == "custom"){
            return redirect('/customCategory');
        }
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
      
        $data['category'] = Category::find($id);
        return view("category.edit", $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
             'image' => 'nullable|mimes:jpg,png,jpeg',
             'title' => 'required',
             'type' => 'required',
        ]);
        
        $posts = Category::find($id);
        $posts->name = $request->get("title");
        $posts->type = $request->get("type");
        
        if($request->get("type") == 'festival'){
            $posts->event_date = $request->get("event_date");
        }else{
            $posts->event_date = null;
        }
        
        
        if ($request->file("image") && $request->file('image')->isValid()) {
            $image = $request->file("image");
            
            $extension = $image->getClientOriginalExtension();
            $fileName = Str::uuid() . '.' . $extension;
            
            if(Setting::getValue('storage_type') == "digitalOccean"){
                $item_url = Storage::disk('spaces')->put('uploads/posts/'.$fileName, file_get_contents($image),'public');
                $thumbnail_url = env("DO_SPACES_URL").'/uploads/posts/'.$fileName;
                $posts->image = $thumbnail_url;
            }else{
                
                $thumbName = Str::uuid() . '.' .$extension;
            
                $image->move('uploads/posts', $fileName);
                $item_url = 'uploads/posts/'.$fileName;
                if($request->get("type") == "political"){
                  $posts->image = $item_url;
                }else{
                  $thumbnail_url = 'uploads/posts/'.$thumbName;

                    switch($extension){ 
                        case 'jpeg':
                            $image = imagecreatefromjpeg($item_url); 
                            break; 
                        case 'png': 
                            $image = imagecreatefrompng($item_url); 
                            break; 
                        case 'gif': 
                            $image = imagecreatefromgif($item_url); 
                            break; 
                        default: 
                            $image = imagecreatefromjpeg($item_url); 
                    }

                    imagejpeg($image, $thumbnail_url, 50);
                   @unlink($item_url);
                  @unlink($posts->image);
                  $posts->image = $thumbnail_url;
                }
                
            }
        }
        
        $posts->save();
        if($request->get("type") == "festival"){
            return redirect('/festivalCategory');
        }
        if($request->get("type") == "business"){
            return redirect('/businessCategory');
        }
        if($request->get("type") == "political"){
            return redirect('/politicalCategory');
        }
        if($request->get("type") == "custom"){
            return redirect('/customCategory');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $posts = Category::find($id);
        @unlink($posts->image);

        Category::find($id)->delete();
        return redirect()->route('category.index');
    }
}
