<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Session;
use App\Model\Admin;

class CustomAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $path = $request->path();
        $publicRoutes = ['login', 'setup', 'databasesetup', 'autoFestivalNotification', 
                        'privacy-policy', 'refund-policy', 'terms-condition'];
        
        if ($path == "setup" || $path == "databasesetup" && !$this->alreadyInstalled()) {
            // Allow setup routes if not installed
        } elseif (!$this->alreadyInstalled()) {
            return redirect("/setup");
        } elseif ($path == "autoFestivalNotification") {
            // Special case for this route
        } elseif ($path == "login" && Session::has('userid')) {
            return redirect("/");
        } elseif (!in_array($path, $publicRoutes) && !Session::has('userid')) {
            return redirect("/login");
        }
        
        return $next($request);
    }
    
    public function alreadyInstalled()
    {
        return (file_exists(public_path('install')) && file_get_contents(public_path('install')) == "posterbanao");
    }
    
}
