<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $title }} - {{\App\Models\Setting::getValue('app_name')}}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            color: #212529;
        }
        .policy-container {
            background: white;
            border-radius: 8px;
            box-shadow: 0 0 20px rgba(0,0,0,0.05);
        }
        .policy-header {
            border-bottom: 1px solid #eee;
            padding-bottom: 1rem;
            margin-bottom: 2rem;
        }
        .policy-title {
            color: #2c3e50;
            font-weight: 700;
        }
        .policy-section {
            margin-bottom: 2.5rem;
        }
        .section-title {
            color: #3490dc;
            font-weight: 600;
            margin-bottom: 1rem;
            border-left: 4px solid #3490dc;
            padding-left: 10px;
        }
        .last-updated {
            font-size: 0.9rem;
            color: #6c757d;
            text-align: right;
        }
        .back-to-home {
            margin-top: 2rem;
            margin-bottom: 2rem;
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="policy-container p-4 p-md-5">
                    <div class="policy-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h1 class="policy-title">{{ $title }}</h1>
                        </div>
                        <p class="lead">This policy describes how we collect, use, and protect your personal information.</p>
                    </div>

                    <div class="policy-content">
                        <!-- Dynamic content from database -->
                        <div class="policy-section">
                            {!! $content !!}
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
</body>
</html>